<?php
/*
	Stempora web framework
	copyright (c) 2002-2016 Stempora
		web:  www.stempora.com
		mail: support@stempora.com

*/

// dependencies
#require_once _LIBPATH . "forms.php";


/**
* description
*
* @library	
* @author	
* @since	
*/
class CFormSettings extends CForm{
	function __construct($xml , $templates , $db , $tables) {
		parent::__construct($templates, $db , $tables,$xml);
		$this->name = "formsettings";

		$this->method = strtoupper($this->form["method"] ? $this->form["method"] : "post");
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Show($values = array() , $extra = array() , $other = null  , $_edit = null) {
		//check if i should show the details
		if (is_array($this->_errors)) {			
			$edit = true;
		} else {
			if ($_SERVER["REQUEST_METHOD"] == "POST") {
				//redirect to the showing mode;
				$location = new CTemplate($this->form["redirect"] , "string");
				URLRedirect($location->Replace(parent::GlobalVars($this->form)) , "js");
			} elseif ($_edit !== null ) {
				$edit = $_edit;
			} else {
				$edit = $_GET["action"] == "edit" || $_GET["action"] == "store" ? true : false;
			}
		}

		if ($edit == false) {

			//convert the editable fields to the showing ones
			if (is_array($this->form["fields"])) {
				parent::__private__showonly($this->form);
			}

			//remove the edit and back buttons
			
			if (!$_GET["returnurl"])
				unset($this->form["buttons"]["back"]);

			unset($this->form["buttons"]["save"]);
			unset($this->form["action"]);

			
		} else {
			//remove the edit button
			unset($this->form["buttons"]["edit"]);
		}
		
		return parent::Show(
					$this->form , 
					is_array($this->_errors) ? $this->_errors : array(
						"values" => $values,
						"error" => $this->error
					),
					$extra
				);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Validate( $form = null , $input = null) {

		if ($_SERVER["REQUEST_METHOD"] != $this->method) 
			return 1;

		if ($this->method == "GET" )
			$data = &$_GET ;
		else
			$data = &$_POST;
		
		CForm::ProcessVariables($this->form, $data);


		if (is_array($this->form["fields"])) {
			
			$form_fields = array();
			foreach ($this->form["fields"] as $key => $val) {

				if ($key == "box") {
					foreach ($this->form["fields"]["box"] as $k => $v) {							

						if (is_array($v["fields"])) {
							$form_fields = array_merge(
								$v["fields"],
								$form_fields
							);
						}
						
					}				
				} else {					
					$form_fields[$key] = $val;
				}

			}				
		} 

		$form = $this->form;
		$form["fields"] = $form_fields;
		
		$this->_errors = parent::Validate($form  , $data);		
		$this->valid = !(int)is_array($this->_errors);		

		//$this->__private_process_uploads();
	}

	function Done() {

		$this->Validate();				
		$this->Uploads();

		if ($this->valid) {
			if ($_SERVER["REQUEST_METHOD"] == "POST") {
				$this->DoUploads();
				return true;
			}
		}

		return false;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Uploads() {

		if (is_array($this->form["fields"])) {
			foreach ($this->form["fields"] as $key => $val) {

				if ($key == "box") {

					foreach ($val as $_k => $box) {

						if (is_array($box["fields"])) {						
							foreach ($box["fields"] as $__k => $__v) {
								if (!$__v["name"])
									$__v["name"] = $__k;

								switch ($__v["type"]) {
									case "upload":						
									case "image":																
										$this->__private_uploads_pre($__v);
										if (CForm::__private_uploads_after($__v)) {
											$_POST[$__k] = "1";
											//remove the other fields
										}

										unset($_POST[$__v["name"] . "_temp"]);
										unset($_POST[$__v["name"] . "_temp_file"]);
										unset($_POST[$__v["name"] . "_radio_type"]);
										unset($_POST[$__v["name"] . "_crop_oxbc"]);
									break;
								}

							}
						}
						
					}
					
				}
				
				if (!$val["name"])
					$val["name"] = $key;
				
				switch ($val["type"]) {
					case "upload":						
					case "image":						

						
						$this->__private_uploads_pre($val);

						if (CForm::__private_uploads_after($val)) {
							$_POST[$val["name"]] = "1";
							//remove the other fields
						}

						unset($_POST[$val["name"] . "_temp"]);
						unset($_POST[$val["name"] . "_temp_file"]);
						unset($_POST[$val["name"] . "_radio_type"]);
						unset($_POST[$val["name"] . "_crop_oxbc"]);

					break;
				}
				
			}			
		}		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DoUploads() {

		if (is_array($this->form["fields"])) {
			foreach ($this->form["fields"] as $key => $val) {
				if (!$val["name"])
					$val["name"] = $key;
								
				switch ($val["type"]) {
					case "upload":						
					case "image":						
						$this->__private_uploads_after($val);


						//remove the extra fields
						unset($_POST["portfolio_img_temp"]);
						unset($_POST["portfolio_img_radio_type"]);
						unset($_POST["portfolio_img_upload_web"]);
					break;
				}
				
			}			
		}		
	}
	

	

	function DoEvents(){
	}
}


?>